CREATE TABLE Branding ( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),resource_type TEXT NOT NULL,resource_data TEXT NOT NULL,PRIMARY KEY (ProductID, resource_type) )
CREATE TABLE DependencyData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PayloadIDb TEXT ,type TEXT NOT NULL ,product_family TEXT, product_name TEXT, version TEXT, PRIMARY KEY (PayloadID,PayloadIDb,type,product_family,product_name,version))
CREATE TABLE EULA_Files( productID TEXT NOT NULL, langCode TEXT NOT NULL,eula TEXT NOT NULL,PRIMARY KEY (productID, langCode) )
CREATE TABLE PayloadData( PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),domain TEXT NOT NULL,key TEXT NOT NULL,value TEXT NOT NULL,PRIMARY KEY (PayloadID, domain, key) )
CREATE TABLE Payloads( PayloadID TEXT NOT NULL, payload_family TEXT NOT NULL,payload_name TEXT NOT NULL, payload_version TEXT NOT NULL,payload_type TEXT NOT NULL,PRIMARY KEY (PayloadID) )
CREATE TABLE SuitePayloads( ProductID TEXT NOT NULL REFERENCES Suites (ProductID),PayloadID TEXT NOT NULL REFERENCES Payloads (PayloadID),PRIMARY KEY (ProductID, PayloadID) )
CREATE TABLE Suites( ProductID TEXT NOT NULL, group_name TEXT NOT NULL, group_family TEXT NOT NULL, display_name TEXT NOT NULL, PRIMARY KEY (ProductID) )
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{F46EAF19-C62E-409E-8A85-2546E14851EC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{5E38EA8F-106D-436d-9A43-5EDB151AA993}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{4713F905-F06A-4E78-AED9-AEB164125487}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{4A470B9B-D64A-4B65-803A-AA6967C62170}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{BE2AAA07-8F95-4435-B615-1D33451716AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{4A1CFA3E-71C0-42C6-A19D-415801ACF37A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{95A564CD-E7F6-4954-B714-ACBFECA4FF0B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{3952DD6D-DA69-401A-878B-26637F91F360}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{63EF4929-2979-4785-B0B9-BEAF4127EE2F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{4FABAFE1-B867-408A-8F77-1E7453E7126B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{06EA00A3-4461-4461-8731-4FD9DA167D35}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{5A142F95-DF85-4C7C-9BE7-206989934CFD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{60371889-ED9E-41F4-9A2F-48862028FE2A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{6B405F32-374A-43A5-83D2-26BE82F96248}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{258673B7-C6B8-408A-B38B-9D8F268BD507}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{1ED0BFB4-1694-449A-9AD4-BC024D7A840B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{27E50586-0555-4923-8E4D-A08F1D641C2A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{5982B3BA-7A64-4D6E-B222-0D00285DC597}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{AD878506-1A03-4110-9702-656E99304248}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{D4BA0EDD-1963-4730-84EB-095F1195C543}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{4195A1DB-E747-4EF6-91B7-658256482E10}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{E6680F4C-0CC7-4ADF-8023-52063F668AFF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{15D245E9-17AB-462E-B87A-8A3A734F0F9E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{6FE253BF-1104-4A93-BB95-C4392DC366B9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{11929797-5CD5-4233-AB54-101FCDD3A03F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{D8474C7F-5259-4ABF-BD64-F20F4AFD392A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{9EF9D2E8-9664-4147-B7F3-FA4B80E4AD18}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{97A8E954-D267-4769-9853-3EF0F259EA06}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{4B11CA64-0B86-4453-AC06-57BD649861FB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{8C96E7A9-E060-41F0-AA59-5678E5C307D5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{6A5544C8-F418-43D8-9D27-4E19C3BB5E7B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{0ADC08F2-B744-4049-B240-36441554FA41}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{78F39EC8-134D-4660-BE4F-E7C4E17B1E5C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{0CD2C592-13B7-47B6-BBF5-FB4C50C1AEC3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{E020BDA2-D099-4E31-8586-44853EC7E690}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{50D5136F-839D-42F3-9343-6F5A62B53939}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{A54A83C6-0F5F-4A9E-ABE9-5F19FD91B20D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{D39D3599-AB31-41CD-8BC4-5B79D49B99D2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{A6F92A3C-AC45-424D-BE21-0654C6D2B3F1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{1BC7B3EC-517D-436D-BA47-9DD95A94E06F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{AC9E45EC-A422-4121-90B4-EC4A395AD8C1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{E9EB523D-D667-44EB-A804-77F24AA91E6C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{3E0E007C-C85D-4ADC-9F16-EBED21D26CC2}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{522A4B68-0282-4C67-82D2-CC1323FE3FE4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{C84DEB4C-8F82-4DCC-9273-7952B40F7ED7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{79CA2C27-7BD0-4CD9-8D17-1FCE7CC820B1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{CD086B29-15D3-4DA8-8E98-1CB71B1DF015}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{9145DE9B-3564-4872-83FC-EE11BB0E491E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{A093C0C5-0408-4B7B-B5AC-099254FB03D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{4FF0F828-D0FC-479F-9F1A-3BFE75CA184B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{E5941A84-4868-4597-9071-E2C5ECF59B53}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{24C06C12-2AC5-444B-A919-3E44B7E0D686}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{784A98B3-FC86-43D1-8342-8248A786790E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{04801B4C-B7A1-4D70-A6B1-79BBCCFE6ACA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{0383261E-6EEB-400A-90CD-97F63C9F23F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{C0C9BCD1-5189-4549-9AA3-7407FDA4827D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{70EAEC3B-E722-4C13-9BBD-690B79134BFD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{3DE08C59-2178-49A5-A8A2-0CD316A80DFA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{FA8C6B01-839B-4BDB-934C-13F538A94F5F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{3099756C-3E45-405E-9B06-219139105CFD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{47243908-0E10-49C9-9F86-BB9FF8AFF840}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{C71101D9-5B2D-43B6-B779-5855D4D489A4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{8B784A1A-4312-4C62-BB75-DEFC8D7595D5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{0413E679-4D23-4EE5-BD93-EA09BB6980F3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{DC9D0DB2-9F8A-4F3C-854D-7287A2F502F9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{D934114F-4497-4B45-905F-DACC40AC3C15}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{DAB1A990-CF4E-4CC9-B8BB-F99EAB65452E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{EA9F770F-5332-4C11-96AF-C91DB344E8A9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{34F296FE-C6AF-4DB2-B314-CBF29B088733}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{EC9B1B78-06EE-4522-9AD8-31575B9E8202}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{EEEAF7B2-51FE-4AAB-B26E-83B83DEEFB97}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{BDB8D7DF-37DF-456F-AE2C-C51A888A6016}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{1482B68A-AA94-4679-A696-B268CF44AF9E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{C2162B86-A64C-4664-80CA-93B418F34F78}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{13D064F7-4896-489C-BE38-F342A7CC4896}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{CEF75904-C47F-4439-8ED4-B3884586DD09}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{B5482CC1-F23F-48D0-8ADA-03B2879A26EB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{8CEA8CBA-0F88-4601-82A1-AD361AF8980A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{02BF1A34-C7AC-4C3E-B214-C07876381568}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{E4B957A2-C755-4660-A766-1AD59F14A952}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{7E7C5632-F74E-40D8-9EBD-20D4BC8EF3C7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{DEEB0AD2-1CD5-4334-B7E2-6D539FA75484}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{9AE2E4E8-36DF-48BC-9B26-590923874E2D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{58679466-1351-46C3-B271-5E51CD680938}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{C606656D-EDDF-49F0-96DE-0D1F83CA5814}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{CEE07388-92B0-4741-9F2C-0F90168B5BDA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{6552F9F7-A78B-4AA9-B462-37C6B99ED1D1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{5E10FC51-134E-438C-9237-51B08EBAD097}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{93411628-A348-4EBA-B83A-6F3D4F2E827E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{3D2BB002-0F46-44C8-B533-6B5520E4FC87}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{68E382C8-673E-4FD2-A483-6B6CC0B730F5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{58F2C875-38F3-4117-AE3F-BFE5064859E1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{9FB61B98-70B5-44B8-8A52-F05F9528EA66}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{D4A23BFD-85A6-46F1-A45A-0FFE59D2A05D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{4A4F8BB8-7CF3-4450-ABA7-5636ACEEB84A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{00C06D4A-515F-497B-9611-8840511534AB}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{36481681-3DE6-4026-8A9E-83ED1F91CB47}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{57A64018-672B-44E0-9885-2AA88282446C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{34450FE1-EB5A-4F6D-B02C-648FC48D4905}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{F7C48E6F-36D5-45FC-B097-C15FEB2E2847}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{6F142611-13B8-4BDD-B029-A7AB279C9BD8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{E1400D7B-BBE1-4701-B8C0-8FAE93745E17}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{56EC817F-C687-42C4-81E5-BFA90F78D42F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{36692E5F-4CB0-4EC5-A037-403A2602A7AE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{13292C24-1EE6-4B5F-9D6D-E98C478345F9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{6CD7A24E-E72E-49CD-A9F7-CFE1EBC0D7D6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{CE630DD3-2486-4673-B434-7ED71E052F3F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{1F28592B-07A2-4FD6-B59A-A3DA72647FB5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{D4D79BAD-15C0-4E58-BEBA-E76BD03DEB98}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{A46B064D-C24B-4B48-98F7-6F8DC1EBA0D5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{52F56A22-DC2C-4C9C-9773-02705A9B8A5F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{51BE7E92-7359-4935-9168-D376B562E9BE}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{F935222F-D5D8-4915-BBE7-A2087B76C017}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{3211E941-87C5-4CE1-B71B-33967ACCA54D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{C824F6E1-B1A9-439A-AD44-9F84F241AE85}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{A9E54EE3-DD44-4433-A650-C9A8654ADEE6}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{A7136821-7395-4CDE-9418-F857BD764474}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{910DB454-B351-4AF2-9A45-2ECE4D3DE788}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{9D4CBDF4-DC09-46BD-96E0-3BCA955BE13C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{2750B44B-0595-4B51-99B9-327EE4024119}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{AFE64ADA-9458-45B1-A750-39CFDF62976B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{E31EA65A-01F4-4FB1-A5B9-D3B8CBB32BB4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{DAD02C7A-D645-4A84-9203-91BC4B0BD024}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{6981A267-CA4C-4F37-AAA7-BB3D374C0151}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{D391812F-CDBE-4ED4-9FC6-AE0E0E541965}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{A746D681-C3F4-4CF9-A889-056DA46F4D83}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{8C7BE264-E746-42BB-83B1-2ED323E8491F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{A286BA6A-C0A1-4F39-ADE3-DC0529725201}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{AFE0646A-173D-41E9-97D8-72452E72C6D9}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{25055C36-A9A2-491C-817C-CA018745E701}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{BD6ED4DB-C4D6-4DD3-8542-9F559A69EAD4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{AA6A3650-7D04-428A-BB49-0808F00F8196}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{C2C1E2EA-AF73-4F0D-A4EA-CA899D2BD58A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{6D42A91E-7A94-4523-A0C8-88CD10765636}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{AD9C9492-FFC2-4BB9-A13F-0B29C7F9FFF7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{D663BEF0-3485-48F2-990A-C82194CDDF69}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{1CDFAA0A-12A3-46C0-884A-6E44DA606DCA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{2AEF1C35-2D14-42F5-8F1C-A04327B5966E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{F117A0FB-5C64-4025-9C69-8DD98FF94D28}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{5D2602BA-787B-4B82-A0D7-BE3E1E2E89A8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{C1E4C0F6-5AD5-43FF-AF19-7FA55319AA9E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{FEBBD97F-340E-4564-911C-41CCB5FE6661}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{FDA3D25A-CA84-400A-947E-E2157FFFAECA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{80B37CC5-88CF-40FE-AEC3-984B56A86C54}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{BD33ACFF-D9B2-4033-8809-2EE354ECAEF3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{8DB90744-4EE8-4577-8A9C-EE1DDF1E96BC}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{F3B002EB-8070-4014-855B-175BB2851B42}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{7828BA26-86B7-4674-AFF1-A386BDA78CBF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{B43B075C-77AE-4A89-B030-97977914BD44}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{D56C2484-9243-4FFC-9F13-0C152E2E7E0D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{C0AC0C1A-2A4B-4B14-9FB6-96FFFABF4537}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{49BCF039-A434-4E7D-94FE-F9908C60E052}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{BA4E645D-966D-4C96-A4A1-A9729C51B9F1}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{02D81C1A-234F-4062-9E0E-C7FE2C8200D4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{B418BC21-BAD2-48D0-96FC-7C7CB70FDB1E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{7E1D0A40-D494-448B-B52E-1FAC1361E61E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{6CBA3044-857F-4325-AA4C-C7E3F405268B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{F0B6DC5D-F6A2-459D-9ECE-1ADA9B897441}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{0F7C54A4-0E13-445D-92DE-BD53E166460D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{E78B534D-9CA3-4CB6-8B43-3A40A83123F8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{86C36B7C-F423-42B4-BBFE-C72FA7DE934E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{19A37370-091C-43CB-821D-E10825432934}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{DB355314-07C9-40F6-8FF9-D31FFA894B49}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{A4EC440C-024D-48B8-8674-175A136A369F}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{CA711759-9FD7-4887-8106-0B78B320B11C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{E32C92FA-5048-4598-9440-B71924D22189}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{A4751C6B-C13F-4AFF-9C06-E98E8B23792E}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{B43E977C-33DA-44D9-A38A-D894A62E0767}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{F9C47909-6140-41CA-B484-464FF64CACD5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{3D4D5E35-810D-4B0B-92A0-DEB8A36811D7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{8F4824F9-ABE8-4ED8-8840-079199DD2828}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{4D09D8B4-69AF-4BF0-9C5C-FC7B813F436D}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{12A68B28-A1AA-4098-8448-1F0AE6741617}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{846933F8-FFC2-420F-BE1E-0EB2750A7532}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{FB96548A-9293-4534-96D4-76DBE8B5EF33}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{E6EBCADF-B9B3-471E-9F30-161F80F2070B}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{C47C1A87-32EA-4FAF-8C44-1CC8E3550149}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{5D6BB7DB-41AF-436A-A96B-25505FF090C8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{1A434883-28D3-4190-B738-277B04A948D8}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{34ED0200-CB88-440F-A0D4-EA24DA1DFB5A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{7C8415B7-D75B-47F9-A2BC-1EB5B113D748}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{C300E3A0-C742-476C-B999-39FC8B51A7A5}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{E5301FAB-D2B6-4F59-9A25-C258E37E94EF}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{02B2AE25-2F4D-4DB4-AAAB-0F824207D7F4}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{DD3A18DE-4226-408B-8D12-FA26710AF421}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{C797E07C-80A5-4127-8C61-F225A7FD15E3}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{7CB2FA0E-E91C-4ED4-A6E8-74EAD7C5A612}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{1D8F5EFF-EA61-417E-A1C7-C1C134A9C2CD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{64BD4602-7010-4A60-9BD5-A3774AF17572}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{E0A121D9-8D09-4DBE-B495-0F2D6042E7A7}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{45AAB2B4-861D-4B0D-B613-35E3C83D77DD}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{B7E33423-1F2A-4E63-BF38-4E7F854C443A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{9C8BE58A-33C1-4E4D-9E65-7D1D606ADACA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{9A87AB83-74FE-46FB-955A-9A0D614542DA}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{620E75C7-C67B-4ECB-A858-68E7D012031A}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{2CB6B2B0-F3B2-418A-BFAD-D29334B0704C}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{96071786-26A6-4F8B-8857-FB023F224928}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{023B8027-C89D-466F-812A-B18714789337}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{F6A0CC75-4960-4821-9E9C-71FDE670CF40}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{5B806013-C3B6-4C94-A771-F6D64A898C85}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{C724E707-F4EA-4BCA-9029-83DE928B2F03}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{AA422E07-7073-4DD9-A82D-26F8FD2DA981}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{4551CF95-E325-4EA7-8FA8-A266DC7E3012}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{CF7E16A3-9167-44B9-9350-74C04DD3F965}", "upgrade", "", "", "")
INSERT INTO DependencyData VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "{0EE71A2B-0F15-4687-A1D6-EA59BBFB61BE}", "upgrade", "", "", "")
INSERT INTO Branding VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "AMTConfig", 'PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0idXRmLTgiPz4NCjxDb25maWd1cmF0aW9uPg0K
ICAgIDxQYXlsb2FkPg0KICAgICAgICA8IS0tIGRlZmF1bHRBZG9iZUNvZGUgZm9yIGRldmVsb3Bt
ZW50IHVzZS4gLS0+DQogICAgICAgIDxEYXRhIGtleT0iZGVmYXVsdEFkb2JlQ29kZSI+Q2FtZXJh
X1Jhdy1JbnN0YWxsZXItQWRvYmVDb2RlPC9EYXRhPg0KICAgIDwvUGF5bG9hZD4NCjwvQ29uZmln
dXJhdGlvbj4=')
INSERT INTO Payloads VALUES	("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "Shared Technology", "Photoshop Camera Raw (64 bit)", "6.0", "normal")
INSERT INTO PayloadData VALUES("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "0" , "PayloadInfo", '<PayloadInfo version="3.0.116.0"><BuildInfo>
    <Property name="Created">2010-03-09 17:30:19.325000</Property>
    <Property name="TargetName">AdobeCameraRaw6.0All-x64</Property>
    <Property name="ProcessorFamily">x64</Property>
  </BuildInfo><InstallerProperties>
    <Property name="payloadType">SQLite</Property>
    <Property name="AdobeCode">{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}</Property>
    <Property name="ProductName">Photoshop Camera Raw (64 bit)</Property>
    <Property name="ProductVersion">6.0</Property>
  </InstallerProperties><InstallDir>
    <Platform isFixed="0" name="Default" folderName="">[AdobeCommon]\Plug-Ins\CS5\File Formats</Platform>
  </InstallDir><Languages languageIndependent="1"/><Satisfies>
    <ProductInfo>
	<Family>Shared Technology</Family>
	<ProductName>Photoshop Camera Raw (64 bit)</ProductName>
<ProductVersion>6.0</ProductVersion>
    </ProductInfo>
  </Satisfies><Upgrades>
    <AdobeCode>{F46EAF19-C62E-409E-8A85-2546E14851EC}</AdobeCode>
    <AdobeCode>{5E38EA8F-106D-436d-9A43-5EDB151AA993}</AdobeCode>
    <AdobeCode>{4713F905-F06A-4E78-AED9-AEB164125487}</AdobeCode>
    <AdobeCode>{4A470B9B-D64A-4B65-803A-AA6967C62170}</AdobeCode>
    <AdobeCode>{BE2AAA07-8F95-4435-B615-1D33451716AE}</AdobeCode>
    <AdobeCode>{4A1CFA3E-71C0-42C6-A19D-415801ACF37A}</AdobeCode>
    <AdobeCode>{95A564CD-E7F6-4954-B714-ACBFECA4FF0B}</AdobeCode>
    <AdobeCode>{3952DD6D-DA69-401A-878B-26637F91F360}</AdobeCode>
    <AdobeCode>{63EF4929-2979-4785-B0B9-BEAF4127EE2F}</AdobeCode>
    <AdobeCode>{4FABAFE1-B867-408A-8F77-1E7453E7126B}</AdobeCode>
    <AdobeCode>{06EA00A3-4461-4461-8731-4FD9DA167D35}</AdobeCode>
    <AdobeCode>{5A142F95-DF85-4C7C-9BE7-206989934CFD}</AdobeCode>
    <AdobeCode>{60371889-ED9E-41F4-9A2F-48862028FE2A}</AdobeCode>
    <AdobeCode>{6B405F32-374A-43A5-83D2-26BE82F96248}</AdobeCode>
    <AdobeCode>{258673B7-C6B8-408A-B38B-9D8F268BD507}</AdobeCode>
    <AdobeCode>{1ED0BFB4-1694-449A-9AD4-BC024D7A840B}</AdobeCode>
    <AdobeCode>{27E50586-0555-4923-8E4D-A08F1D641C2A}</AdobeCode>
    <AdobeCode>{5982B3BA-7A64-4D6E-B222-0D00285DC597}</AdobeCode>
    <AdobeCode>{AD878506-1A03-4110-9702-656E99304248}</AdobeCode>
    <AdobeCode>{D4BA0EDD-1963-4730-84EB-095F1195C543}</AdobeCode>
    <AdobeCode>{4195A1DB-E747-4EF6-91B7-658256482E10}</AdobeCode>
    <AdobeCode>{E6680F4C-0CC7-4ADF-8023-52063F668AFF}</AdobeCode>
    <AdobeCode>{15D245E9-17AB-462E-B87A-8A3A734F0F9E}</AdobeCode>
    <AdobeCode>{6FE253BF-1104-4A93-BB95-C4392DC366B9}</AdobeCode>
    <AdobeCode>{11929797-5CD5-4233-AB54-101FCDD3A03F}</AdobeCode>
    <AdobeCode>{D8474C7F-5259-4ABF-BD64-F20F4AFD392A}</AdobeCode>
    <AdobeCode>{9EF9D2E8-9664-4147-B7F3-FA4B80E4AD18}</AdobeCode>
    <AdobeCode>{97A8E954-D267-4769-9853-3EF0F259EA06}</AdobeCode>
    <AdobeCode>{4B11CA64-0B86-4453-AC06-57BD649861FB}</AdobeCode>
    <AdobeCode>{8C96E7A9-E060-41F0-AA59-5678E5C307D5}</AdobeCode>
    <AdobeCode>{6A5544C8-F418-43D8-9D27-4E19C3BB5E7B}</AdobeCode>
    <AdobeCode>{0ADC08F2-B744-4049-B240-36441554FA41}</AdobeCode>
    <AdobeCode>{78F39EC8-134D-4660-BE4F-E7C4E17B1E5C}</AdobeCode>
    <AdobeCode>{0CD2C592-13B7-47B6-BBF5-FB4C50C1AEC3}</AdobeCode>
    <AdobeCode>{E020BDA2-D099-4E31-8586-44853EC7E690}</AdobeCode>
    <AdobeCode>{50D5136F-839D-42F3-9343-6F5A62B53939}</AdobeCode>
    <AdobeCode>{A54A83C6-0F5F-4A9E-ABE9-5F19FD91B20D}</AdobeCode>
    <AdobeCode>{D39D3599-AB31-41CD-8BC4-5B79D49B99D2}</AdobeCode>
    <AdobeCode>{A6F92A3C-AC45-424D-BE21-0654C6D2B3F1}</AdobeCode>
    <AdobeCode>{1BC7B3EC-517D-436D-BA47-9DD95A94E06F}</AdobeCode>
    <AdobeCode>{AC9E45EC-A422-4121-90B4-EC4A395AD8C1}</AdobeCode>
    <AdobeCode>{E9EB523D-D667-44EB-A804-77F24AA91E6C}</AdobeCode>
    <AdobeCode>{3E0E007C-C85D-4ADC-9F16-EBED21D26CC2}</AdobeCode>
    <AdobeCode>{522A4B68-0282-4C67-82D2-CC1323FE3FE4}</AdobeCode>
    <AdobeCode>{C84DEB4C-8F82-4DCC-9273-7952B40F7ED7}</AdobeCode>
    <AdobeCode>{79CA2C27-7BD0-4CD9-8D17-1FCE7CC820B1}</AdobeCode>
    <AdobeCode>{CD086B29-15D3-4DA8-8E98-1CB71B1DF015}</AdobeCode>
    <AdobeCode>{9145DE9B-3564-4872-83FC-EE11BB0E491E}</AdobeCode>
    <AdobeCode>{A093C0C5-0408-4B7B-B5AC-099254FB03D8}</AdobeCode>
    <AdobeCode>{4FF0F828-D0FC-479F-9F1A-3BFE75CA184B}</AdobeCode>
    <AdobeCode>{E5941A84-4868-4597-9071-E2C5ECF59B53}</AdobeCode>
    <AdobeCode>{24C06C12-2AC5-444B-A919-3E44B7E0D686}</AdobeCode>
    <AdobeCode>{784A98B3-FC86-43D1-8342-8248A786790E}</AdobeCode>
    <AdobeCode>{04801B4C-B7A1-4D70-A6B1-79BBCCFE6ACA}</AdobeCode>
    <AdobeCode>{0383261E-6EEB-400A-90CD-97F63C9F23F5}</AdobeCode>
    <AdobeCode>{C0C9BCD1-5189-4549-9AA3-7407FDA4827D}</AdobeCode>
    <AdobeCode>{70EAEC3B-E722-4C13-9BBD-690B79134BFD}</AdobeCode>
    <AdobeCode>{3DE08C59-2178-49A5-A8A2-0CD316A80DFA}</AdobeCode>
    <AdobeCode>{FA8C6B01-839B-4BDB-934C-13F538A94F5F}</AdobeCode>
    <AdobeCode>{3099756C-3E45-405E-9B06-219139105CFD}</AdobeCode>
    <AdobeCode>{47243908-0E10-49C9-9F86-BB9FF8AFF840}</AdobeCode>
    <AdobeCode>{C71101D9-5B2D-43B6-B779-5855D4D489A4}</AdobeCode>
    <AdobeCode>{8B784A1A-4312-4C62-BB75-DEFC8D7595D5}</AdobeCode>
    <AdobeCode>{0413E679-4D23-4EE5-BD93-EA09BB6980F3}</AdobeCode>
    <AdobeCode>{DC9D0DB2-9F8A-4F3C-854D-7287A2F502F9}</AdobeCode>
    <AdobeCode>{D934114F-4497-4B45-905F-DACC40AC3C15}</AdobeCode>
    <AdobeCode>{DAB1A990-CF4E-4CC9-B8BB-F99EAB65452E}</AdobeCode>
    <AdobeCode>{EA9F770F-5332-4C11-96AF-C91DB344E8A9}</AdobeCode>
    <AdobeCode>{34F296FE-C6AF-4DB2-B314-CBF29B088733}</AdobeCode>
    <AdobeCode>{EC9B1B78-06EE-4522-9AD8-31575B9E8202}</AdobeCode>
    <AdobeCode>{EEEAF7B2-51FE-4AAB-B26E-83B83DEEFB97}</AdobeCode>
    <AdobeCode>{BDB8D7DF-37DF-456F-AE2C-C51A888A6016}</AdobeCode>
    <AdobeCode>{1482B68A-AA94-4679-A696-B268CF44AF9E}</AdobeCode>
    <AdobeCode>{C2162B86-A64C-4664-80CA-93B418F34F78}</AdobeCode>
    <AdobeCode>{13D064F7-4896-489C-BE38-F342A7CC4896}</AdobeCode>
    <AdobeCode>{CEF75904-C47F-4439-8ED4-B3884586DD09}</AdobeCode>
    <AdobeCode>{B5482CC1-F23F-48D0-8ADA-03B2879A26EB}</AdobeCode>
    <AdobeCode>{8CEA8CBA-0F88-4601-82A1-AD361AF8980A}</AdobeCode>
    <AdobeCode>{02BF1A34-C7AC-4C3E-B214-C07876381568}</AdobeCode>
    <AdobeCode>{E4B957A2-C755-4660-A766-1AD59F14A952}</AdobeCode>
    <AdobeCode>{7E7C5632-F74E-40D8-9EBD-20D4BC8EF3C7}</AdobeCode>
    <AdobeCode>{DEEB0AD2-1CD5-4334-B7E2-6D539FA75484}</AdobeCode>
    <AdobeCode>{9AE2E4E8-36DF-48BC-9B26-590923874E2D}</AdobeCode>
    <AdobeCode>{58679466-1351-46C3-B271-5E51CD680938}</AdobeCode>
    <AdobeCode>{C606656D-EDDF-49F0-96DE-0D1F83CA5814}</AdobeCode>
    <AdobeCode>{CEE07388-92B0-4741-9F2C-0F90168B5BDA}</AdobeCode>
    <AdobeCode>{6552F9F7-A78B-4AA9-B462-37C6B99ED1D1}</AdobeCode>
    <AdobeCode>{5E10FC51-134E-438C-9237-51B08EBAD097}</AdobeCode>
    <AdobeCode>{93411628-A348-4EBA-B83A-6F3D4F2E827E}</AdobeCode>
    <AdobeCode>{3D2BB002-0F46-44C8-B533-6B5520E4FC87}</AdobeCode>
    <AdobeCode>{68E382C8-673E-4FD2-A483-6B6CC0B730F5}</AdobeCode>
    <AdobeCode>{58F2C875-38F3-4117-AE3F-BFE5064859E1}</AdobeCode>
    <AdobeCode>{9FB61B98-70B5-44B8-8A52-F05F9528EA66}</AdobeCode>
    <AdobeCode>{D4A23BFD-85A6-46F1-A45A-0FFE59D2A05D}</AdobeCode>
    <AdobeCode>{4A4F8BB8-7CF3-4450-ABA7-5636ACEEB84A}</AdobeCode>
    <AdobeCode>{00C06D4A-515F-497B-9611-8840511534AB}</AdobeCode>
    <AdobeCode>{36481681-3DE6-4026-8A9E-83ED1F91CB47}</AdobeCode>
    <AdobeCode>{57A64018-672B-44E0-9885-2AA88282446C}</AdobeCode>
    <AdobeCode>{34450FE1-EB5A-4F6D-B02C-648FC48D4905}</AdobeCode>
    <AdobeCode>{F7C48E6F-36D5-45FC-B097-C15FEB2E2847}</AdobeCode>
    <AdobeCode>{6F142611-13B8-4BDD-B029-A7AB279C9BD8}</AdobeCode>
    <AdobeCode>{E1400D7B-BBE1-4701-B8C0-8FAE93745E17}</AdobeCode>
    <AdobeCode>{56EC817F-C687-42C4-81E5-BFA90F78D42F}</AdobeCode>
    <AdobeCode>{36692E5F-4CB0-4EC5-A037-403A2602A7AE}</AdobeCode>
    <AdobeCode>{13292C24-1EE6-4B5F-9D6D-E98C478345F9}</AdobeCode>
    <AdobeCode>{6CD7A24E-E72E-49CD-A9F7-CFE1EBC0D7D6}</AdobeCode>
    <AdobeCode>{CE630DD3-2486-4673-B434-7ED71E052F3F}</AdobeCode>
    <AdobeCode>{1F28592B-07A2-4FD6-B59A-A3DA72647FB5}</AdobeCode>
    <AdobeCode>{D4D79BAD-15C0-4E58-BEBA-E76BD03DEB98}</AdobeCode>
    <AdobeCode>{A46B064D-C24B-4B48-98F7-6F8DC1EBA0D5}</AdobeCode>
    <AdobeCode>{52F56A22-DC2C-4C9C-9773-02705A9B8A5F}</AdobeCode>
    <AdobeCode>{51BE7E92-7359-4935-9168-D376B562E9BE}</AdobeCode>
    <AdobeCode>{F935222F-D5D8-4915-BBE7-A2087B76C017}</AdobeCode>
    <AdobeCode>{3211E941-87C5-4CE1-B71B-33967ACCA54D}</AdobeCode>
    <AdobeCode>{C824F6E1-B1A9-439A-AD44-9F84F241AE85}</AdobeCode>
    <AdobeCode>{A9E54EE3-DD44-4433-A650-C9A8654ADEE6}</AdobeCode>
    <AdobeCode>{A7136821-7395-4CDE-9418-F857BD764474}</AdobeCode>
    <AdobeCode>{910DB454-B351-4AF2-9A45-2ECE4D3DE788}</AdobeCode>
    <AdobeCode>{9D4CBDF4-DC09-46BD-96E0-3BCA955BE13C}</AdobeCode>
    <AdobeCode>{2750B44B-0595-4B51-99B9-327EE4024119}</AdobeCode>
    <AdobeCode>{AFE64ADA-9458-45B1-A750-39CFDF62976B}</AdobeCode>
    <AdobeCode>{E31EA65A-01F4-4FB1-A5B9-D3B8CBB32BB4}</AdobeCode>
    <AdobeCode>{DAD02C7A-D645-4A84-9203-91BC4B0BD024}</AdobeCode>
    <AdobeCode>{6981A267-CA4C-4F37-AAA7-BB3D374C0151}</AdobeCode>
    <AdobeCode>{D391812F-CDBE-4ED4-9FC6-AE0E0E541965}</AdobeCode>
    <AdobeCode>{A746D681-C3F4-4CF9-A889-056DA46F4D83}</AdobeCode>
    <AdobeCode>{8C7BE264-E746-42BB-83B1-2ED323E8491F}</AdobeCode>
    <AdobeCode>{A286BA6A-C0A1-4F39-ADE3-DC0529725201}</AdobeCode>
    <AdobeCode>{AFE0646A-173D-41E9-97D8-72452E72C6D9}</AdobeCode>
    <AdobeCode>{25055C36-A9A2-491C-817C-CA018745E701}</AdobeCode>
    <AdobeCode>{BD6ED4DB-C4D6-4DD3-8542-9F559A69EAD4}</AdobeCode>
    <AdobeCode>{AA6A3650-7D04-428A-BB49-0808F00F8196}</AdobeCode>
    <AdobeCode>{C2C1E2EA-AF73-4F0D-A4EA-CA899D2BD58A}</AdobeCode>
    <AdobeCode>{6D42A91E-7A94-4523-A0C8-88CD10765636}</AdobeCode>
    <AdobeCode>{AD9C9492-FFC2-4BB9-A13F-0B29C7F9FFF7}</AdobeCode>
    <AdobeCode>{D663BEF0-3485-48F2-990A-C82194CDDF69}</AdobeCode>
    <AdobeCode>{1CDFAA0A-12A3-46C0-884A-6E44DA606DCA}</AdobeCode>
    <AdobeCode>{2AEF1C35-2D14-42F5-8F1C-A04327B5966E}</AdobeCode>
    <AdobeCode>{F117A0FB-5C64-4025-9C69-8DD98FF94D28}</AdobeCode>
    <AdobeCode>{5D2602BA-787B-4B82-A0D7-BE3E1E2E89A8}</AdobeCode>
    <AdobeCode>{C1E4C0F6-5AD5-43FF-AF19-7FA55319AA9E}</AdobeCode>
    <AdobeCode>{FEBBD97F-340E-4564-911C-41CCB5FE6661}</AdobeCode>
    <AdobeCode>{FDA3D25A-CA84-400A-947E-E2157FFFAECA}</AdobeCode>
    <AdobeCode>{80B37CC5-88CF-40FE-AEC3-984B56A86C54}</AdobeCode>
    <AdobeCode>{BD33ACFF-D9B2-4033-8809-2EE354ECAEF3}</AdobeCode>
    <AdobeCode>{8DB90744-4EE8-4577-8A9C-EE1DDF1E96BC}</AdobeCode>
    <AdobeCode>{F3B002EB-8070-4014-855B-175BB2851B42}</AdobeCode>
    <AdobeCode>{7828BA26-86B7-4674-AFF1-A386BDA78CBF}</AdobeCode>
    <AdobeCode>{B43B075C-77AE-4A89-B030-97977914BD44}</AdobeCode>
    <AdobeCode>{D56C2484-9243-4FFC-9F13-0C152E2E7E0D}</AdobeCode>
    <AdobeCode>{C0AC0C1A-2A4B-4B14-9FB6-96FFFABF4537}</AdobeCode>
    <AdobeCode>{49BCF039-A434-4E7D-94FE-F9908C60E052}</AdobeCode>
    <AdobeCode>{BA4E645D-966D-4C96-A4A1-A9729C51B9F1}</AdobeCode>
    <AdobeCode>{02D81C1A-234F-4062-9E0E-C7FE2C8200D4}</AdobeCode>
    <AdobeCode>{B418BC21-BAD2-48D0-96FC-7C7CB70FDB1E}</AdobeCode>
    <AdobeCode>{7E1D0A40-D494-448B-B52E-1FAC1361E61E}</AdobeCode>
    <AdobeCode>{6CBA3044-857F-4325-AA4C-C7E3F405268B}</AdobeCode>
    <AdobeCode>{F0B6DC5D-F6A2-459D-9ECE-1ADA9B897441}</AdobeCode>
    <AdobeCode>{0F7C54A4-0E13-445D-92DE-BD53E166460D}</AdobeCode>
    <AdobeCode>{E78B534D-9CA3-4CB6-8B43-3A40A83123F8}</AdobeCode>
    <AdobeCode>{86C36B7C-F423-42B4-BBFE-C72FA7DE934E}</AdobeCode>
    <AdobeCode>{19A37370-091C-43CB-821D-E10825432934}</AdobeCode>
    <AdobeCode>{DB355314-07C9-40F6-8FF9-D31FFA894B49}</AdobeCode>
    <AdobeCode>{A4EC440C-024D-48B8-8674-175A136A369F}</AdobeCode>
    <AdobeCode>{CA711759-9FD7-4887-8106-0B78B320B11C}</AdobeCode>
    <AdobeCode>{E32C92FA-5048-4598-9440-B71924D22189}</AdobeCode>
    <AdobeCode>{A4751C6B-C13F-4AFF-9C06-E98E8B23792E}</AdobeCode>
    <AdobeCode>{B43E977C-33DA-44D9-A38A-D894A62E0767}</AdobeCode>
    <AdobeCode>{F9C47909-6140-41CA-B484-464FF64CACD5}</AdobeCode>
    <AdobeCode>{3D4D5E35-810D-4B0B-92A0-DEB8A36811D7}</AdobeCode>
    <AdobeCode>{8F4824F9-ABE8-4ED8-8840-079199DD2828}</AdobeCode>
    <AdobeCode>{4D09D8B4-69AF-4BF0-9C5C-FC7B813F436D}</AdobeCode>
    <AdobeCode>{12A68B28-A1AA-4098-8448-1F0AE6741617}</AdobeCode>
    <AdobeCode>{846933F8-FFC2-420F-BE1E-0EB2750A7532}</AdobeCode>
    <AdobeCode>{FB96548A-9293-4534-96D4-76DBE8B5EF33}</AdobeCode>
    <AdobeCode>{E6EBCADF-B9B3-471E-9F30-161F80F2070B}</AdobeCode>
    <AdobeCode>{C47C1A87-32EA-4FAF-8C44-1CC8E3550149}</AdobeCode>
    <AdobeCode>{5D6BB7DB-41AF-436A-A96B-25505FF090C8}</AdobeCode>
    <AdobeCode>{1A434883-28D3-4190-B738-277B04A948D8}</AdobeCode>
    <AdobeCode>{34ED0200-CB88-440F-A0D4-EA24DA1DFB5A}</AdobeCode>
    <AdobeCode>{7C8415B7-D75B-47F9-A2BC-1EB5B113D748}</AdobeCode>
    <AdobeCode>{C300E3A0-C742-476C-B999-39FC8B51A7A5}</AdobeCode>
    <AdobeCode>{E5301FAB-D2B6-4F59-9A25-C258E37E94EF}</AdobeCode>
    <AdobeCode>{02B2AE25-2F4D-4DB4-AAAB-0F824207D7F4}</AdobeCode>
    <AdobeCode>{DD3A18DE-4226-408B-8D12-FA26710AF421}</AdobeCode>
    <AdobeCode>{C797E07C-80A5-4127-8C61-F225A7FD15E3}</AdobeCode>
    <AdobeCode>{7CB2FA0E-E91C-4ED4-A6E8-74EAD7C5A612}</AdobeCode>
    <AdobeCode>{1D8F5EFF-EA61-417E-A1C7-C1C134A9C2CD}</AdobeCode>
    <AdobeCode>{64BD4602-7010-4A60-9BD5-A3774AF17572}</AdobeCode>
    <AdobeCode>{E0A121D9-8D09-4DBE-B495-0F2D6042E7A7}</AdobeCode>
    <AdobeCode>{45AAB2B4-861D-4B0D-B613-35E3C83D77DD}</AdobeCode>
    <AdobeCode>{B7E33423-1F2A-4E63-BF38-4E7F854C443A}</AdobeCode>
    <AdobeCode>{9C8BE58A-33C1-4E4D-9E65-7D1D606ADACA}</AdobeCode>
    <AdobeCode>{9A87AB83-74FE-46FB-955A-9A0D614542DA}</AdobeCode>
    <AdobeCode>{620E75C7-C67B-4ECB-A858-68E7D012031A}</AdobeCode>
    <AdobeCode>{2CB6B2B0-F3B2-418A-BFAD-D29334B0704C}</AdobeCode>
    <AdobeCode>{96071786-26A6-4F8B-8857-FB023F224928}</AdobeCode>
    <AdobeCode>{023B8027-C89D-466F-812A-B18714789337}</AdobeCode>
    <AdobeCode>{F6A0CC75-4960-4821-9E9C-71FDE670CF40}</AdobeCode>
    <AdobeCode>{5B806013-C3B6-4C94-A771-F6D64A898C85}</AdobeCode>
    <AdobeCode>{C724E707-F4EA-4BCA-9029-83DE928B2F03}</AdobeCode>
    <AdobeCode>{AA422E07-7073-4DD9-A82D-26F8FD2DA981}</AdobeCode>
    <AdobeCode>{4551CF95-E325-4EA7-8FA8-A266DC7E3012}</AdobeCode>
    <AdobeCode>{CF7E16A3-9167-44B9-9350-74C04DD3F965}</AdobeCode>
    <AdobeCode>{0EE71A2B-0F15-4687-A1D6-EA59BBFB61BE}</AdobeCode>
  </Upgrades><Channel enable="1" id="PhotoshopCameraRaw64bit-6.0">
    <DisplayName>Photoshop Camera Raw (64 bit)</DisplayName>
  </Channel><AMTConfig path="[AdobeCommon]\Camera Raw 6\AMT\component.xml"/><InstallDestinationMetadata relocatableSize="0" sysDriveSize="14431700"><Destination>
      <Root>[AdobeCommon]</Root>
      <TotalSize>14431700</TotalSize>
      <MaxPathComponent>/Plug-Ins/CS5/File Formats\Camera Raw.8bi</MaxPathComponent>
    </Destination>
    <Assets>
      <Asset flag="0" name="Assets2_1" size="14431700"/>
    </Assets>
  </InstallDestinationMetadata><ConflictingProcesses>
	<Win32>
	<Process processType="Adobe" blocking="1">^[Aa][Ff][Tt][Ee][Rr][Ff][Xx].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Aa][Dd][Oo][Bb][Ee] [Dd][Nn][Gg] [Cc][Oo][Nn][Vv][Ee][Rr][Tt][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Bb][Rr][Ii][Dd][Gg][Ee].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Dd][Oo][Ww][Nn][Ll][Oo][Aa][Dd][Ee][Rr].[Ee][Xx][Ee]$</Process>
      <Process processType="Adobe" blocking="1">^[Pp][Hh][Oo][Tt][Oo][Ss][Hh][Oo][Pp].[Ee][Xx][Ee]$</Process>
    </Win32>
</ConflictingProcesses><AddRemoveInfo>
    <DisplayVersion>
      <Value lang="sq_AL">6.0</Value>
      <Value lang="ar_AE">6.0</Value>
      <Value lang="be_BY">6.0</Value>
      <Value lang="bg_BG">6.0</Value>
      <Value lang="ca_ES">6.0</Value>
      <Value lang="zh_CN">6.0</Value>
      <Value lang="zh_TW">6.0</Value>
      <Value lang="hr_HR">6.0</Value>
      <Value lang="cs_CZ">6.0</Value>
      <Value lang="da_DK">6.0</Value>
      <Value lang="nl_NL">6.0</Value>
      <Value lang="en_XC">6.0</Value>
      <Value lang="en_XM">6.0</Value>
      <Value lang="en_GB">6.0</Value>
      <Value lang="en_US">6.0</Value>
      <Value lang="et_EE">6.0</Value>
      <Value lang="fi_FI">6.0</Value>
      <Value lang="fr_FR">6.0</Value>
      <Value lang="fr_XM">6.0</Value>
      <Value lang="de_DE">6.0</Value>
      <Value lang="el_GR">6.0</Value>
      <Value lang="he_IL">6.0</Value>
      <Value lang="hu_HU">6.0</Value>
      <Value lang="hi_IN">6.0</Value>
      <Value lang="is_IS">6.0</Value>
      <Value lang="it_IT">6.0</Value>
      <Value lang="ja_JP">6.0</Value>
      <Value lang="ko_KR">6.0</Value>
      <Value lang="lv_LV">6.0</Value>
      <Value lang="lt_LT">6.0</Value>
      <Value lang="mk_MK">6.0</Value>
      <Value lang="nn_NO">6.0</Value>
      <Value lang="no_NO">6.0</Value>
      <Value lang="nb_NO">6.0</Value>
      <Value lang="pl_PL">6.0</Value>
      <Value lang="pt_BR">6.0</Value>
      <Value lang="ro_RO">6.0</Value>
      <Value lang="ru_RU">6.0</Value>
      <Value lang="sh_YU">6.0</Value>
      <Value lang="sk_SK">6.0</Value>
      <Value lang="sl_SI">6.0</Value>
      <Value lang="es_QM">6.0</Value>
      <Value lang="es_ES">6.0</Value>
      <Value lang="sv_SE">6.0</Value>
      <Value lang="th_TH">6.0</Value>
      <Value lang="tr_TR">6.0</Value>
      <Value lang="uk_UA">6.0</Value>
      <Value lang="vi_VN">6.0</Value>
      <Value lang="fr_CA">6.0</Value>
      <Value lang="es_MX">6.0</Value>
    </DisplayVersion>
    <DisplayName>
      <Value lang="sq_AL">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="ar_AE">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="be_BY">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="bg_BG">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="ca_ES">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="zh_CN">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="zh_TW">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="hr_HR">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="cs_CZ">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="da_DK">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="nl_NL">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="en_XC">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="en_XM">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="en_GB">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="en_US">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="et_EE">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="fi_FI">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="fr_FR">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="fr_XM">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="de_DE">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="el_GR">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="he_IL">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="hu_HU">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="hi_IN">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="is_IS">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="it_IT">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="ja_JP">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="ko_KR">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="lv_LV">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="lt_LT">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="mk_MK">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="nn_NO">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="no_NO">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="nb_NO">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="pl_PL">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="pt_BR">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="ro_RO">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="ru_RU">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="sh_YU">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="sk_SK">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="sl_SI">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="es_QM">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="es_ES">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="sv_SE">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="th_TH">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="tr_TR">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="uk_UA">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="vi_VN">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="fr_CA">Photoshop Camera Raw (64 bit)</Value>
      <Value lang="es_MX">Photoshop Camera Raw (64 bit)</Value>
    </DisplayName>
  </AddRemoveInfo><UserPreferences>0</UserPreferences></PayloadInfo>')
INSERT INTO PayloadData VALUES("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "0", "AMTConfigPath", "[AdobeCommon]\Camera Raw 6\AMT\component.xml")
INSERT INTO PayloadData VALUES("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "0", "ChannelID", "PhotoshopCameraRaw64bit-6.0")
INSERT INTO PayloadData VALUES("{61A3D10A-AA4D-4E4C-B9DB-6A08D318EA41}", "0", "ChannelInfo", '<Channel enable="1" id="PhotoshopCameraRaw64bit-6.0">
    <DisplayName>Photoshop Camera Raw (64 bit)</DisplayName>
  </Channel>')
